/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.VerificationUtil;

public class GetAsmDevPathCommand
extends VerificationCommand {
    private static String m_arg1 = "-getasmdevpath";
    private String m_asmStamp = null;

    public GetAsmDevPathCommand(String nodeName, String stamp) {
        super(nodeName, null, null);
        this.m_asmStamp = stamp;
        String[] args = new String[]{m_arg1, this.m_asmStamp};
        super.setArgs(args);
    }

    @Override
    public boolean execute() {
        Trace.out((String)("GetAsmDevPathCommand::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        String[] resultString = this.getCommandResult().getResultString();
        String reoutput = VerificationUtil.strArr2String(resultString);
        Trace.out((String)"super.execute() was succcessful for GetAsmDevPathCommand...");
        String asmDevicePath = null;
        if (!VerificationUtil.fetchExecResult(reoutput)) {
            String trcTxt = "Exectask result shows error for -getasmdevpath...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            Trace.out((String)"resolving of asm stamp to device path failed");
            result.addErrorInfo("resolving of asm stamp to device path failed");
            result.setStatus(2);
            return false;
        }
        if (!VerificationUtil.fetchVerificationStatus(reoutput)) {
            String trcTxt = "Exectask result shows verification failure for -getasmdevpath...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            Trace.out((String)"resolving of asm stamp to device path unsuccessful");
            result.addErrorInfo("resolving of asm stamp to device path unsuccessful");
            result.setStatus(3);
            return false;
        }
        asmDevicePath = VerificationUtil.fetchVerificationValue(reoutput);
        Trace.out((String)"after calling fetchVerificationValue() ");
        Trace.out((String)("The ASM stamp '" + this.m_asmStamp + "' is resolved to device path '" + asmDevicePath + "' on node " + this.getNodeName()));
        result.addTraceInfo("The ASM stamp '" + this.m_asmStamp + "' is resolved to device path '" + asmDevicePath + "' on node " + this.getNodeName());
        result.addResultInfo(asmDevicePath);
        result.setStatus(1);
        return true;
    }
}

